#include <iostream>
#include <set>
using namespace std;

const int MAXN = 1010;

int n, m;
int a[MAXN][MAXN];

set<int> rows, rows_check, rows_erase;
set<int> cols, cols_check, cols_erase;

int inc(set<int> &s, int x) {
  auto it = s.lower_bound(x + 1);
  return it == s.end() ? MAXN : *it;
}

int dec(set<int> &s, int x) {
  auto it = s.lower_bound(x);
  return it == s.begin() ? -1 : *(--it);
}

void check() {
  rows_erase.clear();
  cols_erase.clear();
  for (int i0 : rows_check) {
    int i1 = inc(rows, i0);
    int i2 = inc(rows, i1);
    if (i2 == MAXN) break;
    for (int j : cols) {
      if (a[i0][j] == a[i1][j] && a[i0][j] == a[i2][j])
        cols_erase.insert(j);
    }
  }
  for (int j0 : cols_check) {
    int j1 = inc(cols, j0);
    int j2 = inc(cols, j1);
    if (j2 == MAXN) break;
    for (int i : rows) {
      if (a[i][j0] == a[i][j1] && a[i][j0] == a[i][j2])
        rows_erase.insert(i);
    }
  }
}

bool erase() {
  rows_check.clear();
  cols_check.clear();
  for (int i : rows_erase) {
    for (int j = 0; j < 3; ++j) {
      rows_check.insert(i);
      i = dec(rows, i);
    }
  }
  for (int j : cols_erase) {
    for (int step = 0; step < 3; ++step) {
      cols_check.insert(j);
      j = dec(cols, j);
    }
  }
  for (int i : rows_erase) {
    rows.erase(i);
    rows_check.erase(i);
  }
  for (int j : cols_erase) {
    cols.erase(j);
    cols_check.erase(j);
  }
  rows_check.erase(-1);
  cols_check.erase(-1);

  return !rows_erase.empty() || !cols_erase.empty();
}

int main(void) {
  cin >> n >> m;
  for (int i = 0; i < n; ++i)
    for (int j = 0; j < m; ++j)
      cin >> a[i][j];

  for (int i = 0; i < n; ++i) {
    rows.insert(i);
    rows_check.insert(i);
  }

  for (int j = 0; j < m; ++j) {
    cols.insert(j);
    cols_check.insert(j);
  }

  for (check(); erase(); check());

  for (int i : rows) {
    for (int j : cols)
      cout << a[i][j] << " ";
    cout << endl;
  }

  return 0;
}
